//
//  MCAssistantWindowController.h
//  Assistant
//
//  Created by Alykhan Jetha on 05/04/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <MCApplication/MCWindowController.h>

@class MCAssistantBackgroundView, MCAssistantContentView;

@interface MCAssistantWindowController : MCWindowController {

	IBOutlet MCAssistantContentView *assistantContentView;
	
	id followOnTarget;
	SEL followOnSelector;
	
	BOOL runningModal;
}



- (id)initWithDefinitionFromPath:(NSString *)aPath;
- (void)loadDefinitionFromPath:(NSString *)aPath;

- (void)setFollowOnTarget:(id)object;

// selector must take two arguments - id of the assistant first and the NSNumber second (the runModal return code)
// i.e. (void)assistant:(MCAssistantWindowController *)assist withCode:(NSNumber *)code
- (void)setFollowOnSelector:(SEL)selector;

- (int)runModal;

@end
